from pyiceberg.catalog import load_catalog
import pyarrow.parquet as pq

# Define the catalog
warehouse_path = "warehouse"
catalog = load_catalog(
    "default",
    **{
        'type': 'sql',
        "uri": f"sqlite:///{warehouse_path}/pyiceberg_catalog.db",
        "warehouse": f"file://{warehouse_path}",
    },
)

# Read some data
df = pq.read_table("../parquet-data/people/part-00.parquet")

# Create the table
catalog.create_namespace("default")
table = catalog.create_table(
    "default.people",
    schema=df.schema,
)
table.append(df)

# Read it back
print("table listing: {}\n", catalog.list_tables('default'))
df2 = table.scan().to_arrow()
print(df2)

