import os
import fnmatch
from ID3Sharp import ID3v2Tag, ID3v1Tag

class TagStats(object):

    FIELDS = ('Genre', 'Artist', 'Album')

    def __init__(self):
        self.total = 0
        self.tagless = 0
        self.genres = set()
        self.artists = set()
        self.albums = set()


    def collect(self, basePath):
        for mp3Path in self.walkAndMatch(basePath, self.isMp3):
            tag = ID3v2Tag.ReadTag(mp3Path)
            if tag is None:
                tag = ID3v1Tag.ReadTag(mp3Path)
            if tag is not None:
                for field in self.FIELDS:
                    fieldSet = getattr(self, field.lower()+'s')
                    fieldSet.add(getattr(tag, field))
                self.total += 1
            else:
                self.tagless += 1

    def walkAndMatch(self, basePath, matcher):
        for root, _, files in os.walk(basePath):
            for name in (n for n in files if matcher(n)):
                yield os.path.join(root, name)

    @staticmethod
    def isMp3(filename):
        return fnmatch.fnmatch(filename, '*.mp3')
