import AddReferences
from System import ArgumentException
from System.Windows.Forms import (Application, DialogResult,
        FolderBrowserDialog, MessageBox, MessageBoxButtons,
        MessageBoxIcon)
from CSharp import MainFormBase
from tags import TagStats

class MainForm(MainFormBase):

    def __init__(self):
        MainFormBase.__init__(self)

        self._folderDialog = FolderBrowserDialog()
        self._folderDialog.ShowNewFolderButton = False

        self.pathTextBox.Text = r'C:\Documents and Settings\Administrator\My Documents\Music\Compilations'
        self.browseButton.Click += self.onBrowse
        self.goButton.Click += self.onGo

    def onBrowse(self, _, __):
        self._folderDialog.SelectedPath = self.pathTextBox.Text
        if self._folderDialog.ShowDialog() == DialogResult.OK:
            self.pathTextBox.Text = self._folderDialog.SelectedPath

    def onGo(self, _, __):
        try:
            stats = TagStats()
            stats.collect(self.pathTextBox.Text)
        except (IOError, ArgumentException):
            MessageBox.Show(
                    "Problem occurred while reading mp3 files. Check the path.",
                    "Error",
                    MessageBoxButtons.OK, MessageBoxIcon.Exclamation)

        self.totalLabel.Text = str(stats.total)
        self.genresLabel.Text = str(len(stats.genres))
        self.artistsLabel.Text = str(len(stats.artists))
        self.albumsLabel.Text = str(len(stats.albums))
        self.missingTagsLabel.Text = str(stats.tagless)


Application.Run(MainForm())
